(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     11967,        219]
NotebookOptionsPosition[     10865,        188]
NotebookOutlinePosition[     11665,        215]
CellTagsIndexPosition[     11595,        210]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Preface", "Section",
 CellChangeTimes->{{3.961290599406513*^9, 3.961290601230685*^9}},
 FontFamily->".AppleSystemUIFont",
 FontWeight->"Regular",
 FontColor->GrayLevel[0],
 CellTags->"Preface",ExpressionUUID->"a2919825-f216-4c5a-8e24-a4cd0d35d3a9"],

Cell[TextData[{
 "Finite elements have become the standard way of solving many problems in \
structural mechanics. Many specialist structural analysis programs \
incorporate finite elements, often in the form of two-dimensional, membrane, \
and shell elements, which are essentially two-dimensional elements in \
three-dimensional space where the thickness is small compared to the area. \
Few support solid 3D elements. Those that do, such as ANSYS, COMSOL, and \
SOLIDWORKS, are, often, very expensive. They are fine if your workload can \
support them, and they do have the advantage of specialist support for \
standards, etc. On the other hand, Mathematica is reasonably priced and \
justifiable as a general calculation tool for most engineers.  With it comes \
a finite element package that is very comprehensive and suitable for \
structural, fluid, and heat problems. Its strength lies in its generality, \
but the lack of examples directly relevant to a civil or structural engineer \
may mean it is not used as widely as it should be. \n\nThis book has been \
designed to overcome this by making it easier to use Mathematica for the \
types of problems commonly encountered by structural or civil engineers. It \
covers, in this volume, the linear elastic solution of solid mechanics i. e., \
full 3D elements in 3D space. The use of 2D shell elements in 3D space is not \
covered. \n\nThe analysis itself is only a small part of the process. The \
problem has to be formulated, and a model has to be created. It then has to \
be analysed and solved for the displacements. The solution must then be \
processed to give results that are meaningful and useful, such as finding the \
bending moments or stresses. These again have to be processed so that, if it \
is a concrete problem for example, they are in the correct form for the \
design of the reinforcement. \n\nThis book attempts to cover all these \
issues. It does not go into the theory. There are many books on the theory of \
finite elements, and the Mathematica documentation covers both the process of \
setting up and solving the underlying equations very well. However, working \
through the examples in this book should give engineers confidence to tackle \
most problems with little difficulty. \n\nThe book commences by solving \
simple problems such as slabs or walls and comparing the solution to standard \
solutions such as those by ",
 StyleBox["Timoshenko", "Reference"],
 ". This introduces the process and shows how to go from the solution for \
displacement to bending moments. The models become more complex as the book \
progresses. Various boundary conditions are discussed, and ways of applying \
loads are shown. Different methods of constructing the model, either from \
within Mathematica or by importing models constructed in a CAD program, are \
demonstrated. Several cases of structure/soil interaction are shown with the \
soil modelled in various ways. \n\nProblems of plasticity are not modelled in \
this book. Plastic problems are to be found in Volume 2 (In preparation). \
One-dimensional or stick elements (i. e., beams and columns) are also not \
covered, although a program to solve such problems could readily be written \
in Mathematica. Nevertheless, users will find that many cases they will meet \
in their everyday work, such as slabs, retaining walls, tanks and basements, \
pad and raft foundations, and many cases of soil/structure interaction, are \
covered and are straightforward to solve. \n\nWhile this book is limited to \
linear elastic solutions, this does cover most engineering structures at \
serviceability limit states, where displacement is the main criterion. It \
also covers metal structures at any state where stresses are below the yield \
point. Even many soil problems can be solved at working load. In particular, \
it is very suitable for many cases of soil/structure interaction. \n\nOne \
advantage of using Mathematica is that the whole job can be produced in one \
notebook, right through from initial design to final report, with all the \
calculations contained within the same document. Sections can be left open or \
closed, remain evaluatable or not as required, depending on the use to which \
the notebook is put. It forms a very good, complete record of the design. "
}], "Text",
 CellChangeTimes->{{3.964080858843145*^9, 3.9640809649029303`*^9}, {
   3.964080996872129*^9, 3.964081002631297*^9}, {3.9640810421573*^9, 
   3.964081081553363*^9}, {3.964081147170388*^9, 3.964081150680078*^9}, 
   3.96408861203902*^9, {3.964088679544104*^9, 3.964088679678578*^9}, {
   3.964088714061716*^9, 3.964088765818472*^9}, {3.9640887996428423`*^9, 
   3.9640888168870277`*^9}, {3.964088866856173*^9, 3.964089172478353*^9}, 
   3.964089202703497*^9, 3.964102948688817*^9, {3.9641031009569473`*^9, 
   3.964103158247486*^9}, {3.964103209856718*^9, 3.964103213141333*^9}, {
   3.964276857927799*^9, 3.96427698496976*^9}, 3.964277019226954*^9, {
   3.9676293569758863`*^9, 3.967629477903569*^9}, {3.9676295809444933`*^9, 
   3.9676295864315*^9}, {3.9676297640493526`*^9, 3.9676300133821077`*^9}, {
   3.967630128920259*^9, 3.9676301629666147`*^9}, {3.967630318604189*^9, 
   3.967630321762335*^9}, {3.970537193360077*^9, 3.9705371946931753`*^9}, {
   3.970538097197138*^9, 3.970538110087514*^9}, {3.970538179614963*^9, 
   3.970538253447863*^9}, {3.971782238615237*^9, 3.971782258066038*^9}, {
   3.971922510961012*^9, 3.9719225173250732`*^9}, 3.971922572946701*^9, {
   3.971922650319439*^9, 3.971922736448492*^9}, 3.971922853447302*^9, 
   3.971922889178364*^9, {3.972903216698317*^9, 3.972903226100316*^9}},
 FontWeight->"Regular",ExpressionUUID->"b0cdf0b2-f2db-4795-943d-f0e648493461"],

Cell["\<\
Whilst you do not need to know much theory to make use of this book, It is \
assumed that that the user has a basic understanding of structural mechanics.

The examples have been written out in detail so that the user can follow what \
each step is doing. They may therefore appear \[OpenCurlyDoubleQuote]wordy\
\[CloseCurlyDoubleQuote] and appear to require a lot of typing. This is not \
the case in practice. Much of the input can be reduced to functions. Indeed, \
by careful labelling of parameters, often a model can be created, analysed, \
and plans drawn of bending moment requirements and/or stresses with just one \
line of code for any model of similar shape!

Some of the more complex models may take some time to run. Where this is the \
case I generally have included the time taken on my machine, a Mac Studio M1 \
Ultra, so you can decide whether to wait, or get yourself a coffee. However, \
they have also been run on a Dell machine with 32GB of RAM and under Windows \
and Unix as well as the Macintosh operating system. In this book, there may \
be occasions where I have accepted a coarser mesh than I would in practice to \
keep the calculation time down, but, in any case, it is good practice to set \
up the model and run it with a coarse mesh to ensure that it is set up \
correctly. Then run it again with a fine mesh to ensure the results are \
correct.

To get the best use out of this book, I would recommend that you read the \
first chapter to get an overview of the process. Then you should, ideally, \
work through the examples, writing your own code until you are confident in \
formulating and solving similar problems. Once you are confident you can dip \
into the book for examples close to what you require. I hope you enjoy the \
journey.\
\>", "Text",
 CellChangeTimes->{{3.964089257953719*^9, 3.964089477657045*^9}, {
   3.9640895632801847`*^9, 3.964089575996255*^9}, {3.964089644791074*^9, 
   3.964089937142625*^9}, {3.9640899694827957`*^9, 3.9640902922741013`*^9}, {
   3.964090378343583*^9, 3.964090442425672*^9}, {3.964090492872491*^9, 
   3.964090636038848*^9}, 3.9641019644713306`*^9, {3.964102044777821*^9, 
   3.9641020690792027`*^9}, {3.964277050846014*^9, 3.964277062304562*^9}, 
   3.9676303609433947`*^9, {3.9676304215786324`*^9, 3.9676304542717733`*^9}, {
   3.970537324866148*^9, 3.970537372739874*^9}, {3.970537977950286*^9, 
   3.970538060696864*^9}, {3.971782333376734*^9, 3.97178234066603*^9}, {
   3.971923022479157*^9, 3.971923100587123*^9}},
 FontWeight->"Regular",ExpressionUUID->"362a725b-2b11-4a97-99e3-b2eec8d9ba89"],

Cell[TextData[{
 StyleBox["Next -",
  FontColor->GrayLevel[0]],
 " ",
 Cell[BoxData[
  TemplateBox[{
   "\"\\!\\(\\*StyleBox[\\\"1\\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\\!\\(\\*StyleBox[\\\" \\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\\!\\(\\*StyleBox[\\\"Overview\\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\"", {"Chapter1_Overview.nb", None}, "Chapter1_Overview.nb"},
   "HyperlinkDefault"]],
  CellChangeTimes->{3.974424055926341*^9, 3.9744274989254303`*^9, 
   3.9744363990127068`*^9, 3.9744368757945013`*^9},ExpressionUUID->
  "6f762f1b-b343-4f24-9ab7-c36d7bbcafe6"],
 "                                                                            \
            ",
 Cell[BoxData[
  TemplateBox[{
   "\"\\!\\(\\*StyleBox[\\\"Contents\\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\"", {"Contents.nb", None}, "Contents.nb"},
   "HyperlinkDefault"]],
  CellChangeTimes->{3.974433563494323*^9, 3.974436942557736*^9},
  TextAlignment->Center,
  Background->GrayLevel[0.85],ExpressionUUID->
  "4f04d1fe-1a67-4a44-a1e0-e6b8d4fd97f2"]
}], "Subsubsection",
 CellChangeTimes->{{3.97183704200134*^9, 3.971837063536191*^9}, 
   3.971837115116831*^9, {3.971837162382868*^9, 3.971837165952989*^9}, 
   3.971837250378147*^9, {3.974434031611574*^9, 3.974434065885021*^9}, {
   3.9744369906121492`*^9, 3.974437037461585*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"9a356848-d689-4bc9-a179-36ff3e8bbada"]
}, Open  ]]
},
ScreenStyleEnvironment->"Elegant",
WindowSize->{786, 953},
WindowMargins->{{152, Automatic}, {Automatic, 166}},
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "MyBookStyles.nb"]]}, Visible -> False, 
  FrontEndVersion -> "14.3 for Mac OS X ARM (64-bit) (July 8, 2025)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"925f9181-4335-4a4a-89dc-5a9fd9909c4b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Preface"->{
  Cell[576, 22, 254, 5, 27, "Section",ExpressionUUID->"a2919825-f216-4c5a-8e24-a4cd0d35d3a9",
   CellTags->"Preface"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Preface", 11452, 204}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 254, 5, 27, "Section",ExpressionUUID->"a2919825-f216-4c5a-8e24-a4cd0d35d3a9",
 CellTags->"Preface"],
Cell[833, 29, 5726, 77, 756, "Text",ExpressionUUID->"b0cdf0b2-f2db-4795-943d-f0e648493461"],
Cell[6562, 108, 2593, 40, 317, "Text",ExpressionUUID->"362a725b-2b11-4a97-99e3-b2eec8d9ba89"],
Cell[9158, 150, 1691, 35, 69, "Subsubsection",ExpressionUUID->"9a356848-d689-4bc9-a179-36ff3e8bbada"]
}, Open  ]]
}
]
*)

